/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.AbstractIDMigrator;
import org.apache.mahout.cf.taste.model.UpdatableIDMigrator;
import org.apache.mahout.common.IOUtils;

public abstract class AbstractJDBCIDMigrator
extends AbstractIDMigrator
implements UpdatableIDMigrator {
    public static final String DEFAULT_MAPPING_TABLE = "taste_id_mapping";
    public static final String DEFAULT_LONG_ID_COLUMN = "long_id";
    public static final String DEFAULT_STRING_ID_COLUMN = "string_id";
    private final DataSource dataSource;
    private final String getStringIDSQL;
    private final String storeMappingSQL;

    protected AbstractJDBCIDMigrator(DataSource dataSource, String getStringIDSQL, String storeMappingSQL) {
        this.dataSource = dataSource;
        this.getStringIDSQL = getStringIDSQL;
        this.storeMappingSQL = storeMappingSQL;
    }

    @Override
    public final void storeMapping(long longID, String stringID) throws TasteException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.storeMappingSQL);
            stmt.setLong(1, longID);
            stmt.setString(2, stringID);
            stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new TasteException(sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt, conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, stmt, conn);
    }

    @Override
    public final String toStringID(long longID) throws TasteException {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getStringIDSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(1);
            stmt.setLong(1, longID);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            String string2 = rs.getString(1);
            IOUtils.quietClose(rs, stmt, conn);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException sqle) {
            try {
                throw new TasteException(sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(rs, stmt, conn);
        return string;
    }

    @Override
    public void initialize(Iterable<String> stringIDs) throws TasteException {
        for (String stringID : stringIDs) {
            this.storeMapping(this.toLongID(stringID), stringID);
        }
    }
}

