/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.stats;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;

public final class IntWeightedMean
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private long totalWeight;
    private double mean;

    public IntWeightedMean() {
        this(0L, Double.NaN);
    }

    private IntWeightedMean(long totalWeight, double mean) {
        this.totalWeight = totalWeight;
        this.mean = mean;
    }

    @Override
    public IntWeightedMean copy() {
        return new IntWeightedMean(this.totalWeight, this.mean);
    }

    @Override
    public void clear() {
        this.totalWeight = 0L;
        this.mean = Double.NaN;
    }

    @Override
    public double getResult() {
        return this.mean;
    }

    @Override
    public long getN() {
        return this.totalWeight;
    }

    @Override
    public void increment(double datum) {
        this.increment(datum, 1);
    }

    public void increment(double datum, int weight) {
        long oldTotalWeight = this.totalWeight;
        this.totalWeight += (long)weight;
        this.mean = oldTotalWeight <= 0L ? datum : this.mean * (double)oldTotalWeight / (double)this.totalWeight + datum * (double)weight / (double)this.totalWeight;
    }

    public void decrement(double datum) {
        this.decrement(datum, 1);
    }

    public void decrement(double datum, int weight) {
        long oldTotalWeight = this.totalWeight;
        this.totalWeight -= (long)weight;
        if (this.totalWeight <= 0L) {
            this.clear();
        } else {
            this.mean = this.mean * (double)oldTotalWeight / (double)this.totalWeight - datum * (double)weight / (double)this.totalWeight;
        }
    }

    public String toString() {
        return Double.toString(this.mean);
    }
}

