% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whitening.R
\name{whitening}
\alias{whitening}
\title{This function provides an estimation of the inverse of the square root of the covariance matrix of each row of the residuals matrix.}
\usage{
whitening(residuals, typeDep, pAR = 1, qMA = 0)
}
\arguments{
\item{residuals}{the residuals matrix obtained by fitting a linear model to each column of the response matrix as if they were independent}

\item{typeDep}{character in c("AR1", "ARMA", "nonparam") defining which type of dependence to use}

\item{pAR}{numerical, only use if typeDep = "ARMA", the parameter p for the ARMA(p, q) process}

\item{qMA}{numerical, only use if typeDep = "ARMA", the parameter q for the ARMA(p, q) process}
}
\value{
It returns the estimation of the inverse of the square root of the covariance matrix of each row of the residuals matrix.
}
\description{
This function provides an estimation of the inverse of the square root of the covariance matrix of each row of the residuals matrix.
}
\examples{
data(copals_camera)
Y=scale(Y[,1:100])
X <- model.matrix( ~ group + 0)
residuals=lm(as.matrix(Y)~X-1)$residuals
whitening(residuals, "AR1")
}
