% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_Poly_HN_Multi}
\alias{Hermite_Poly_HN_Multi}
\title{Multivariate T-Hermite polynomials}
\usage{
Hermite_Poly_HN_Multi(x, N, Sig2 = diag(length(x)))
}
\arguments{
\item{x}{the d-vector of values at which to evaluate the polynomials}

\item{N}{the maximum order of polynomials}

\item{Sig2}{the covariance matrix; default value is the unit matrix diag(length(x))}
}
\value{
The list of d-variate polynomials of order from 1 to N evaluated at vector x
}
\description{
Computes the multivariate T-Hermite polynomials up to order N
at vector variate x with covariance matrix Sig2
}
\examples{
x<-c(1,3)
N<-3
Sig2<- diag(length(x)) # matrix(c(1,0,0,1),2,2,byrow = T)
Hermite_Poly_HN_Multi(x,N)
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.6.2, (4.73), p.223
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Inv}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
