% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multivariate.R
\name{Multivariate}
\alias{Multivariate}
\alias{Multivariate,}
\alias{multivariate}
\title{Multivariate genome-wide association scan}
\usage{
Multivariate(x, trait.idx = NULL, ...)
}
\arguments{
\item{x}{An object created by \code{\link{MultiLoad}}.}

\item{trait.idx}{A vector giving the indices of traits to be analyzed.}

\item{...}{not used.}
}
\value{
The function returns a data frame containing the multi-trait GWAS results, where the row names are
the variants names. The column names are: variant name (\code{Marker}), allele frequency (\code{Freq}),
the smallest sample size of the traits (\code{N}), effect on the phenotype score (\code{Beta.S}, see reference),
standard error (\code{SE}), p-value (\code{P}), and the rest the coefficients to construct the phenotype score
(see reference).
}
\description{
The function imports GenABEL (gwaa.data class) or DatABEL (.fv*) data formats
and performs multivariate test for each genetic variant using multivariate
analysis of variance (MANOVA).
}
\note{
Either \code{gwaa.data} (for GenABEL data format) or the combination of 
\code{phenofile} and \code{genofile} (for DatABEL data format) has to be provided.
If all are provided, only \code{phenofile} and \code{genofile} will be used. When using
DatABEL format input, individual IDs in \code{phenofile} and \code{genofile} have to match!
}
\examples{

## loading example gwaa.data in GenABEL
require(GenABEL)
data(ge03d2ex.clean)

## running multivariate GWAS for 3 traits: height, weight, bmi
loaded <- MultiLoad(gwaa.data = ge03d2ex.clean, trait.cols = c(5, 6, 8), 
                    covariate.cols = c(2, 3))

## running the multivariate GWAS 
res <- Multivariate(loaded)

}
\references{
Xia Shen, ..., Jim Wilson, Gordan Lauc, Yurii Aulchenko (2015).
Multi-omic-variate analysis identified novel loci associated with 
compound N-Glycosylation of human Immunoglobulin G. \emph{Submitted}.
}
\seealso{
\code{\link{MultiLoad}}
}
\author{
Xia Shen
}
\keyword{multivariate}
