% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct.R
\name{reconstructRecursive}
\alias{reconstructRecursive}
\title{Apply a clustering algorithm recursively to a given time course.}
\usage{
reconstructRecursive(
  readouts,
  method = "kmedoids",
  sim = MultIS::getSimilarityMatrix(readouts = readouts, upper = TRUE),
  splitSimilarity = 0.7,
  combineSimilarity = 0.9,
  useSilhouette = TRUE,
  clusterObj = FALSE
)
}
\arguments{
\item{readouts}{The time course for which to find clusters.}

\item{method}{Either "kmedoids", "kmeans" or any string permitted as a method for stats::hclust.}

\item{sim}{A similarity matrix used with all methods except "kmeans".}

\item{splitSimilarity}{Similarity Threshold. If any two elements within a cluster are below this threhsold, another split is initiated.}

\item{combineSimilarity}{After Splitting, a combination phase is activated. If any two elements between two clusters have a similarity higher than this threshold, the cluster are combined.}

\item{useSilhouette}{If TRUE, silhouette is used to define number of cluster during splitting, otherwise cluster are always splitted into two new clusters.}

\item{clusterObj}{If TRUE, a clusterObject with the readouts, similarity and clustering is returned.}
}
\value{
A matrix with two columns: "Clone" and "Barcode" or if clusterObj = TRUE a cluster object, which can be used to plot the clustering.
}
\description{
Apply a clustering algorithm recursively to a given time course.
}
