% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityImprovement.R
\name{mortalityImprovement}
\alias{mortalityImprovement}
\alias{mortalityImprovement,mortalityTable-method}
\title{Return the mortality trend (yearly log-death-probability improvement) of the given period or the given generation.}
\usage{
mortalityImprovement(object, ..., Period = NULL, YOB = 1975)

\S4method{mortalityImprovement}{mortalityTable}(object, ..., Period = NULL, YOB = 1975)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{...}{Other parameters (currently unused)}

\item{Period}{The observation year for which the mortality improvement should
be calculated. If both YOB and Period are given, YOB is ignored.}

\item{YOB}{The birth year for which the mortality improvement should be calculated}
}
\description{
Return the mortality trend (yearly log-death-probability improvement) of the given period or the given generation.
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Return the yearly log-mortality improvement of the
life table given the birth or observation year
}}

\examples{
mortalityTables.load("Austria_Annuities")
# AVOe 2005R includes a trend decline by default, compare the exact table
# with the table without decline:
mortalityImprovement(AVOe2005R.male, Period = 2017)
mortalityImprovement(AVOe2005R.male.nodamping, Period = 2017)

}
