% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOmega.R, R/mortalityTable.jointLives.R
\docType{methods}
\name{getOmega}
\alias{getOmega}
\alias{getOmega,mortalityTable.period-method}
\alias{getOmega,mortalityTable.mixed-method}
\alias{getOmega,mortalityTable.jointLives-method}
\title{Return the maximum age of the life table}
\usage{
getOmega(object)

\S4method{getOmega}{mortalityTable.period}(object)

\S4method{getOmega}{mortalityTable.mixed}(object)

\S4method{getOmega}{mortalityTable.jointLives}(object)
}
\arguments{
\item{object}{A life table object (instance of a \code{mortalityTable} class)}
}
\description{
Return the maximum age of the life table
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable.period}: Return the maximum age of the period life table

\item \code{mortalityTable.mixed}: Return the maximum age of the mixed life table

\item \code{mortalityTable.jointLives}: Return the maximum age of the joint lives mortality table (returns the maximum age of the first table used for joint lives, as the ages of the joint lives are now known to the function)
}}

\examples{
mortalityTables.load("Austria_Annuities")
getOmega(AVOe2005R.male)
getOmega(mortalityTable.deMoivre(omega = 100))

}
