% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{def_ldk_angle}
\alias{def_ldk_angle}
\alias{def_ldk_direction}
\alias{def_ldk_direction.default}
\alias{def_ldk_direction.Out}
\alias{def_ldk_direction.Opn}
\title{Add new landmarks based on angular positions}
\usage{
def_ldk_angle(coo, angle)

def_ldk_direction(coo, direction = c("down", "left", "up", "right")[4])

\method{def_ldk_direction}{default}(coo, direction = c("down", "left", "up", "right")[4])

\method{def_ldk_direction}{Out}(coo, direction = c("down", "left", "up", "right")[4])

\method{def_ldk_direction}{Opn}(coo, direction = c("down", "left", "up", "right")[4])
}
\arguments{
\item{coo}{a code{Out} or \code{Opn} object}

\item{angle}{\code{numeric} an angle in radians (0 by default).}

\item{direction}{\code{character} one of \code{"down", "left", "up", "right"} ("right" by default)}
}
\description{
A wrapper on \link{coo_intersect_angle} and \link{coo_intersect_direction} for
\link{Out} and \link{Opn} objects.
}
\note{
any existing ldk will be preserved.
}
\examples{
# adds a new landmark towards south east
hearts \%>\%
   slice(1:5) \%>\% # for speed purpose only
   def_ldk_angle(-pi/6) \%>\%
stack()

# on Out and towards NW and NE here
olea \%>\%
   slice(1:5) \%>\% #for speed purpose only
   def_ldk_angle(3*pi/4) \%>\%
   def_ldk_angle(pi/4) \%>\%
   stack

}
\seealso{
Typically used before \link{coo_slice} and \link{coo_slide}.
See \link{def_ldk_tips} as well.
}
