% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_centsize}
\alias{coo_centsize}
\title{Calculates centroid size}
\usage{
coo_centsize(coo)
}
\arguments{
\item{coo}{\code{matrix} of \verb{(x; y)} coordinates or any \link{Coo} object.}
}
\value{
\code{numeric}, the centroid size.
}
\description{
Calculates centroid size
}
\details{
This function can be used to integrate size - if meaningful -
to Coo objects. See also \link{coo_length} and \link{rescale}.
}
\examples{
coo_centsize(bot[1])
# on a Coo
coo_centsize(bot)
# add it to $fac
mutate(bot, size=coo_centsize(bot))
}
\seealso{
Other centroid functions: 
\code{\link{coo_centdist}()},
\code{\link{coo_centpos}()}
}
\concept{centroid functions}
\concept{coo_utilities}
