% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{is_equallyspacedradii}
\alias{is_equallyspacedradii}
\title{Tests if coordinates likely have equally spaced radii}
\usage{
is_equallyspacedradii(coo, thres)
}
\arguments{
\item{coo}{\code{matrix} of \code{(x; y)} coordinates or any \link{Coo} object.}

\item{thres}{numeric a threshold (arbitrarily \code{pi/90}, eg 2 degrees, by default)}
}
\value{
a single or a vector of \code{logical}. If \code{NA} are returned,
some coordinates are likely identical, at least for x or y.
}
\description{
Returns TRUE/FALSE whether the sd of angles between all successive
radii is below/above \code{thesh}
}
\examples{
bot[1] \%>\% is_equallyspacedradii
bot[1] \%>\% coo_samplerr(36) \%>\% is_equallyspacedradii
# higher tolerance but wrong
bot[1] \%>\% coo_samplerr(36) \%>\% is_equallyspacedradii(thres=5*2*pi/360)
# coo_interpolate is a better option
bot[1] \%>\% coo_interpolate(1200) \%>\% coo_samplerr(36) \%>\% is_equallyspacedradii
# Coo method
bot \%>\% coo_interpolate(360) \%>\% coo_samplerr(36) \%>\% is_equallyspacedradii
}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}},
  \code{\link{coo_is_closed}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}},
  \code{\link{coo_likely_clockwise}}, \code{\link{coo_nb}},
  \code{\link{coo_perim}}, \code{\link{coo_range}},
  \code{\link{coo_rev}}, \code{\link{coo_right}},
  \code{\link{coo_rotatecenter}}, \code{\link{coo_rotate}},
  \code{\link{coo_sample_prop}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}}
}
