% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-ldk-procrustes.R
\name{fgProcrustes}
\alias{fgProcrustes}
\title{Full Generalized Procrustes alignment between shapes}
\usage{
fgProcrustes(x, tol, coo)
}
\arguments{
\item{x}{an array, a list of configurations, or an \link{Out}, \link{Opn} or \link{Ldk} object}

\item{tol}{numeric when to stop iterations}

\item{coo}{logical, when working on \code{Out} or \code{Opn}, whether to use \code{$coo} rather than \code{$ldk}}
}
\value{
a list with components:
\itemize{
\item \code{rotated} array of superimposed configurations
\item \code{iterationnumber} number of iterations
\item \code{Q} convergence criterion
\item \code{Qi} full list of Q
\item \code{Qd} difference between successive Q
\item \code{interproc.dist} minimal sum of squared norms of pairwise differences between
all shapes in the superimposed sample
\item \code{mshape} mean shape configuration
\item \code{cent.size} vector of centroid sizes.
} or an \link{Out}, \link{Opn} or an \link{Ldk} object.
}
\description{
Directly borrowed from Claude (2008), called there the \code{fgpa2} function.
}
\details{
If performed on an \link{Out} or an \link{Opn} object, will try to use the \code{$ldk} slot,
if landmarks have been previousy defined, then (with a message) on the \code{$coo} slot,
but in that case, all shapes must have the same number of coordinates (\link{coo_sample} may help).
}
\note{
Slightly less optimized than procGPA in the shapes package (~20% on my machine).
Will be optimized when performance will be the last thing to improve!
Silent message and progress bars (if any) with \code{options("verbose"=FALSE)}.
}
\examples{
\dontrun{
# on Ldk
stack(wings)
fgProcrustes(wings, tol=0.1) \%>\% stack()

# on Out
stack(hearts)
fgProcrustes(hearts) \%>\%  stack()
}
}
\references{
Claude, J. (2008). Morphometrics with R. Analysis (p. 316). Springer.
}
\seealso{
Other procrustes functions: \code{\link{fProcrustes}},
  \code{\link{fgsProcrustes}}, \code{\link{pProcrustes}}
}
