% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_sample_prop}
\alias{coo_sample_prop}
\title{Sample a proportion of coordinates (among points)}
\usage{
coo_sample_prop(coo, prop = 1)
}
\arguments{
\item{coo}{either a \code{matrix} of (x; y) coordinates or an \link{Out} or an \link{Opn} object.}

\item{prop}{\code{numeric}, the proportion of points to sample}
}
\value{
a \code{matrix} of (x; y) coordinates, or an \link{Out} or an \link{Opn} object.
}
\description{
A simple wrapper around \link{coo_sample}
}
\details{
As for \link{coo_sample} if an \code{$ldk} component is defined,
it is changed accordingly by multiplying the ids by n over the number of coordinates.
}
\examples{
# single shape
bot[1] \%>\% coo_nb()
bot[1] \%>\% coo_sample_prop(0.5) \%>\% coo_nb()
}
\seealso{
Other sampling functions: \code{\link{coo_extract}},
  \code{\link{coo_interpolate}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}}

Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}},
  \code{\link{coo_is_closed}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}},
  \code{\link{coo_likely_clockwise}}, \code{\link{coo_nb}},
  \code{\link{coo_perim}}, \code{\link{coo_range}},
  \code{\link{coo_rev}}, \code{\link{coo_right}},
  \code{\link{coo_rotatecenter}}, \code{\link{coo_rotate}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_equallyspacedradii}}
}
