% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{arrange}
\alias{arrange}
\title{Arranges (ala dplyr) on Momocs objects}
\usage{
arrange(.data, ...)
}
\arguments{
\item{.data}{a \code{Coo}, \code{Coe}, \code{PCA} object}

\item{...}{logical conditions}
}
\value{
a Momocs object of the same class.
}
\description{
Arange shapes by variables, from the \code{$fac}. See examples and \code{?dplyr::arrange}.
}
\details{
dplyr verbs are maintained.
}
\examples{
olea
# we create a new column
olea \%>\% mutate(id=1:length(.)) \%$\% fac$id
# same but now, shapes are arranged in a desc order, based on id
olea \%>\% mutate(id=1:length(.)) \%>\% arrange(desc(id)) \%$\% fac$id
}
\seealso{
Other handling functions: \code{\link{at_least}},
  \code{\link{chop}}, \code{\link{combine}},
  \code{\link{dissolve}}, \code{\link{filter}},
  \code{\link{mutate}}, \code{\link{rename}},
  \code{\link{rm_uncomplete}}, \code{\link{rw_fac}},
  \code{\link{sample_frac}}, \code{\link{sample_n}},
  \code{\link{select}}, \code{\link{slice}},
  \code{\link{subset.Coo}}, \code{\link{transmute}}
}

