% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuralLearning.R
\name{LearningHC}
\alias{LearningHC}
\title{Score-based hybrid Bayesian Network structure learning}
\usage{
LearningHC(dataset, numIntervals = NULL)
}
\arguments{
\item{dataset}{A dataset with discrete and continuous variables. If the discrete
variables are not of class \code{"factor"}, they are automatically converted.}

\item{numIntervals}{A \code{"numeric"} value indicating the number of categories 
used when discretizing a continuous variable, corresponding to intervals of
equal width. By default it is \code{NULL}, meaning that the continuous variables
are not discretized.}
}
\value{
The output is a \code{"bn"} object containing the learned graph.
}
\description{
Learn the structure of a hybrid Bayesian network using the \bold{hill climbing}
local search method.
}
\details{
\code{LearningHC()} automatically converts non-numeric variables into factors
before calling function \code{hc()} from the \code{bnlearn} package. \code{LearningHC()} can also 
be used to discretize the dataset, using the equal width method, before calling \code{hc()}.
}
\examples{

## Data
data(ecoli)
ecoli <- ecoli[,-1] ## Sequence Name

## DAG1
dag1 <- LearningHC(ecoli)
dag1
plot(dag1)

## DAG2
dag2 <- LearningHC(ecoli, numIntervals = 10)
dag2
plot(dag2)


}
\seealso{
\link{hc}
}
