% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{createNodeSet}
\alias{createNodeSet}
\title{createNodeSet}
\usage{
createNodeSet(x = NULL, isPresent = NULL, considerWhenSampling = NULL)
}
\arguments{
\item{x}{Either a single number indicating how many items are in this nodeset
or a vector from 1:n_items.}

\item{isPresent}{Currently not in use.}

\item{considerWhenSampling}{A boolean/logical vector of the length of the nodeset.
Only in use in special cases.
If the nodeset indicates a location, considerWhenSampling indicates whether the
location is a possible destination, or is only an origin (e.g. a training facility).
Entries in the vector of locations that cannot be a destination are FALSE.
If the nodeset indicates mobile individuals, considerWhenSampling indicates whether
their mobility should be modelled or whether it is structurally determined, that
is, their mobility is exogenously defined and does not follow the same logic as
the mobility of everybody else.}
}
\value{
An object of class "nodeSet.monan".
}
\description{
Determines and names the nodesets of individuals and locations that make up the mobility network.
}
\examples{
# create an object of class nodeSet.monan
people <- createNodeSet(1:nrow(mobilityEdgelist))
organisations <- createNodeSet(length(orgRegion))
}
\seealso{
\code{\link[=createProcessState]{createProcessState()}}
}
