% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.costs.R
\name{compute.costs}
\alias{compute.costs}
\title{Compute costs of a breeding program}
\usage{
compute.costs(population, phenotyping.costs = 10,
  genotyping.costs = 100, fix.costs = 0, fix.costs.annual = 0,
  profit.per.bv = 1, database = NULL, gen = NULL, cohorts = NULL,
  interest.rate = 1, base.gen = 1)
}
\arguments{
\item{population}{population-list}

\item{phenotyping.costs}{Costs for the generation of a phenotype}

\item{genotyping.costs}{Costs for the geneation of a genotype}

\item{fix.costs}{one time occuring fixed costs}

\item{fix.costs.annual}{annually occuring fixed costs}

\item{profit.per.bv}{profit generated by bv per animal}

\item{database}{Groups of individuals to consider}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{interest.rate}{Applied yearly interest rate}

\item{base.gen}{Base generation (application of interest rate)
data(ex_pop)
compute.costs(ex_pop, gen=1:5)}
}
\value{
Cost-table for selected gen/database/cohorts of a population-list
}
\description{
Function to derive the costs of a breeding program / population-list
}
