% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sn_AserialVec.R
\name{Sn_AserialVec}
\alias{Sn_AserialVec}
\title{Computes the Moebius Cramer-von Mises statistics for the test of randomness}
\usage{
Sn_AserialVec(Y, p, trunc.level = 2)
}
\arguments{
\item{Y}{Time series.}

\item{p}{Number of consecutive observations for the test.}

\item{trunc.level}{Only subsets of cardinality <= trunc.level (default=2) are considered for the Moebius statistics.}
}
\value{
\item{stats}{Cramer-von Mises Moebius statistics}

\item{cardA}{cardinality of subsets}

\item{M}{Matrix for multitpliers bootstrap for stats}

\item{Asets}{vector of (0,1) for Moebius subsets}

\item{Sn}{Cramer-von Mises Sn statistic}

\item{J}{Matrix for multipliers bootstrap for Sn}
}
\description{
This function he Moebius Cramer-von Mises statistics for a tests of randomness for random vectors Y(1), ...l, X(p).
}
\references{
B.R Nasri (2022). Tests of serial dependence for arbitrary distributions

#'@examples
Y <- data(Y)
out <- Sn_Aserial(Y,5,2)
}
\keyword{internal}
