% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matnormlda.R
\name{matrixqda}
\alias{matrixqda}
\title{Quadratic Discriminant Analysis for Matrix Variate Observations}
\usage{
matrixqda(
  x,
  grouping,
  prior,
  tol = 1e-04,
  method = "normal",
  nu = 10,
  ...,
  subset
)
}
\arguments{
\item{x}{3-D array of matrix data indexed by the third dimension}

\item{grouping}{vector}

\item{prior}{a vector of prior probabilities of the same length
as the number of classes}

\item{tol}{by default, \code{1e-4}. Tolerance parameter checks
for 0 variance.}

\item{method}{whether to use the normal distribution (\code{normal}) or the
t distribution (\code{t}). By default, normal.}

\item{nu}{If using the t-distribution, the degrees of freedom parameter. By
default, 10.}

\item{...}{Arguments passed to or from other methods, such
as additional parameters to pass to \code{MLmatrixnorm} (e.g.,
\code{row.mean})}

\item{subset}{An index vector specifying the cases to be used in the
training sample.  (NOTE: If given, this argument must be
named.)}
}
\value{
Returns a list of class \code{matrixqda} containing
the following components:
\describe{
\item{\code{prior}}{the prior probabilities used.}
\item{\code{counts}}{the counts of group membership}
\item{\code{means}}{the group means.}
\item{\code{U}}{the between-row covariance matrices}
\item{\code{V}}{the between-column covariance matrices}
\item{\code{lev}}{levels of the grouping factor}
\item{\code{N}}{The number of observations used.}
\item{\code{method}}{The method used.}
\item{\code{nu}}{The degrees of freedom parameter
if the t-distribution was used.}
\item{\code{call}}{The (matched) function call.}
}
}
\description{
See \code{matrixlda}: quadratic discriminant analysis for matrix
variate observations.
}
\details{
This uses \code{MLmatrixnorm} or \code{MLmatrixt} to find the means and
variances for the case when different groups have different variances.
}
\examples{
set.seed(20180221)
# construct two populations of 3x4 random matrices with different means
A <- rmatrixnorm(30, mean = matrix(0, nrow = 3, ncol = 4))
B <- rmatrixnorm(30, mean = matrix(1, nrow = 3, ncol = 4))
C <- array(c(A, B), dim = c(3, 4, 60)) # combine together
groups <- c(rep(1, 30), rep(2, 30)) # define groups
prior <- c(.5, .5) # set prior
D <- matrixqda(C, groups, prior)
logLik(D)
print(D)
}
\references{
\preformatted{G Z Thompson, R Maitra, W Q Meeker, A Bastawros (2019),
"Classification with the matrix-variate-t distribution", arXiv
e-prints arXiv:1907.09565 <https://arxiv.org/abs/1907.09565>
}

Venables, W. N. & Ripley, B. D. (2002) Modern Applied Statistics with
S. Fourth Edition. Springer, New York. ISBN 0-387-95457-0\preformatted{Pierre Dutilleul.  The MLE algorithm for the matrix normal distribution.
Journal of Statistical Computation and Simulation, (64):105–123, 1999.
}
}
\seealso{
\code{\link[=predict.matrixqda]{predict.matrixqda()}}, \code{\link[MASS:qda]{MASS::qda()}},
\code{\link[=MLmatrixnorm]{MLmatrixnorm()}}, \code{\link[=MLmatrixt]{MLmatrixt()}},
\code{\link[=matrixlda]{matrixlda()}}, and \code{\link[=matrixmixture]{matrixmixture()}}
}
