% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixAll.R
\docType{data}
\name{HeartDisease.cat}
\alias{HeartDisease.cat}
\alias{HeartDisease}
\alias{HeartDisease.cont}
\alias{HeartDisease.target}
\title{Mixed data : Cleveland Heart Disease Data}
\format{
Three data frames with 303 observations on the following 14 variables.

\describe{
 \item{\code{age}}{age in years}
 \item{\code{sex}}{sex (1 = male; 0 = female)}
 \item{\code{cp}}{chest pain type. 1: typical angina, 2: atypical angina,
                                   3: non-anginal pain, 4: asymptomatic }
\item{\code{trestbps}}{resting blood pressure (in mm Hg on admission to the  hospital)}
\item{\code{chol}}{serum cholestoral in mg/dl }
\item{\code{fbs}}{(fasting blood sugar > 120 mg/dl)  (1 = true; 0 = false)}
\item{\code{restecg}}{ resting electrocardiographic results.
   0: normal,
   1: having ST-T wave abnormality (T wave inversions and/or ST,
   elevation or depression of > 0.05 mV)
   2: showing probable or definite left ventricular hypertrophy by Estes\' criteria}
\item{\code{thalach}}{ maximum heart rate achieved}
\item{\code{exang}}{exercise induced angina (1 = yes; 0 = no)}
\item{\code{oldpeak}}{ST depression induced by exercise relative to rest}
\item{\code{slope}}{the slope of the peak exercise ST segment
       1: upsloping,
       2: flat,
       3: downsloping}
\item{\code{ca}}{number of major vessels (0-3) colored by flourosopy (4 missing values)}
\item{\code{thal}}{3 = normal; 6 = fixed defect; 7 = reversable defect (2 missing values)}
\item{\code{ num}}{diagnosis of heart disease (angiographic disease status).
              0: < 50% diameter narrowing
              1: > 50% diameter narrowing
    (in any major vessel: attributes 59 through 68 are vessels)}
}
}
\source{
Author: David W. Aha (aha 'AT' ics.uci.edu) (714) 856-8779

Donors: The data was collected from the Cleveland Clinic Foundation (cleveland.data)

https://archive.ics.uci.edu/ml/datasets/Heart+Disease

Detrano, R., Janosi, A., Steinbrunn, W., Pfisterer, M., Schmid, J., Sandhu, S., Guppy, K., Lee, S., & Froelicher, V. (1989). International application of a new probability algorithm for the diagnosis of coronary artery disease. American Journal of Cardiology, 64,304--310.

David W. Aha & Dennis Kibler. "Instance-based prediction of heart-disease presence with the Cleveland database."

Gennari, J.H., Langley, P, & Fisher, D. (1989). Models of incremental concept formation. Artificial Intelligence, 40, 11--61.
}
\description{
The Cleveland Heart Disease Data found in the UCI machine learning
repository consists of 14 variables measured on 303 individuals who have
heart disease. The individuals had been grouped into five levels of heart
disease. The information about the disease status is in the
\code{HeartDisease.target} data set.
}
\details{
The variables consist of five continuous and eight discrete attributes, the
former in the \code{HeartDisease.cont} data set and the later in the
\code{HeartDisease.cat} data set. Three of the discrete attributes have two levels,
three have three levels and two have four levels. There are six missing
values in the data set.
}
\examples{
summary(data(HeartDisease.cat))
summary(data(HeartDisease.cont))
summary(data(HeartDisease.target))
}
\keyword{datasets}
