% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{treemap_pq}
\alias{treemap_pq}
\title{Plot treemap of 2 taxonomic levels}
\usage{
treemap_pq(
  physeq,
  lvl1,
  lvl2,
  nb_seq = TRUE,
  log10trans = TRUE,
  plot_legend = FALSE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{lvl1}{(required) Name of the first (higher) taxonomic rank of interest}

\item{lvl2}{(required) Name of the second (lower) taxonomic rank of interest}

\item{nb_seq}{(logical; default TRUE) If set to FALSE, only the number of ASV
is count. Concretely, physeq otu_table is transformed in a binary
otu_table (each value different from zero is set to one)}

\item{log10trans}{(logical, default TRUE) If TRUE,
the number of sequences (or ASV if nb_seq = FALSE) is log10
transformed.}

\item{plot_legend}{(logical, default FALSE) If TRUE, plot che
legend of color for lvl 1}

\item{...}{Other arguments passed on to \code{\link[treemapify:geom_treemap]{treemapify::geom_treemap()}} function.}
}
\value{
A ggplot2 graphic
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Note that lvl2need to be nested in lvl1
}
\examples{
data(data_fungi_sp_known)
if (requireNamespace("treemapify")) {
  treemap_pq(
    clean_pq(subset_taxa(
      data_fungi_sp_known,
      Phylum == "Basidiomycota"
    )),
    "Order", "Class",
    plot_legend = TRUE
  )
}
\donttest{
if (requireNamespace("treemapify")) {
  treemap_pq(
    clean_pq(subset_taxa(
      data_fungi_sp_known,
      Phylum == "Basidiomycota"
    )),
    "Order", "Class",
    log10trans = FALSE
  )
  treemap_pq(
    clean_pq(subset_taxa(
      data_fungi_sp_known,
      Phylum == "Basidiomycota"
    )),
    "Order", "Class",
    nb_seq = FALSE, log10trans = FALSE
  )
}
}
}
\author{
Adrien Taudière
}
