% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggscatt_pq}
\alias{ggscatt_pq}
\title{Scatterplot with marginal distributions and statistical results against
Hill diversity of phyloseq object}
\usage{
ggscatt_pq(
  physeq,
  num_modality,
  hill_scales = c(0, 1, 2),
  rarefy_by_sample = FALSE,
  one_plot = TRUE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{num_modality}{(required) Name of the numeric column in
\code{physeq@sam_data} to plot and test against hill numberk}

\item{hill_scales}{(a vector of integer) The list of q values to compute
the hill number H^q. If Null, no hill number are computed. Default value
compute the Hill number 0 (Species richness), the Hill number 1
(exponential of Shannon Index) and the Hill number 2 (inverse of Simpson
Index).}

\item{rarefy_by_sample}{(logical, default FALSE) If TRUE, rarefy
samples using \code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth()}} function.}

\item{one_plot}{(logical, default FALSE) If TRUE, return a unique
plot with the three plot inside using the patchwork package.}

\item{...}{Other arguments passed on to \code{\link[ggstatsplot:ggscatterstats]{ggstatsplot::ggscatterstats()}}
function.}
}
\value{
Either an unique ggplot2 object (if one_plot is TRUE) or
a list of ggplot2 plot for each hill_scales.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Basically a wrapper of function \code{\link[ggstatsplot:ggscatterstats]{ggstatsplot::ggscatterstats()}} for
object of class phyloseq and Hill number.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{ggstatsplot::ggscatterstats()} if you
use this function.
}
\examples{
if (requireNamespace("ggstatsplot")) {
  ggscatt_pq(data_fungi_mini, "Time", type = "non-parametric")
  ggscatt_pq(data_fungi_mini, "Time", hill_scales = 1:4, type = "parametric")
  ggscatt_pq(data_fungi_mini, "Sample_id",
    hill_scales = c(0, 0.5),
    one_plot = FALSE
  )
}
}
\seealso{
\code{\link[=ggbetween_pq]{ggbetween_pq()}}
}
\author{
Adrien Taudière
}
