% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rmse}
\alias{rmse}
\title{Root-mean-squared error}
\usage{
rmse(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{mse}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted root-mean-squared error of predicted values. Equals the square root of mean-squared error.
}
\examples{
rmse(1:10, (1:10)^2)
rmse(1:10, (1:10)^2, w = rep(1, 10))
rmse(1:10, (1:10)^2, w = 1:10)

}
\seealso{
\code{\link{mse}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
