# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name unique_vector
#' @noRd
#'
NULL

#' @name set_diff
#' @noRd
#'
NULL

#' @name c_basis2
#' @title CB construction
#' @description The SVD-based constraint basis construction for non-overlapping
#' subsets of constraints. Algorithm 1 from the reference.
#' Creating a basis from the matrix A
#' @param A [nxk matrix] must have rank k
#' @param eps_limit [double] used as a limit of small value
#' @return T (n x n) the basis matrix
#' @noRd
#'
c_basis2 <- function(A, eps_limit = 1e-10) {
    .Call(`_MetricGraph_c_basis2`, A, eps_limit)
}

construct_constraint_matrix <- function(E, nV, edge_constraint) {
    .Call(`_MetricGraph_construct_constraint_matrix`, E, nV, edge_constraint)
}

construct_directional_constraint_matrix <- function(E, nV, nE, alpha, V_indegree, V_outdegree) {
    .Call(`_MetricGraph_construct_directional_constraint_matrix`, E, nV, nE, alpha, V_indegree, V_outdegree)
}

#' @name proj_vec
#' @noRd
NULL

#' @name proj_vec2
#' @noRd
NULL

#' @name proj_vec
#' @noRd
NULL

#' @name proj_vec_line
#' @noRd
NULL

#' @name assemble_fem
#' @title Construction of FEM matrices
#' @description Function used to construct FEM matrices on metric graphs.
#' @param E [nx2 matrix] Matrix of edges
#' @param h_e [n vector] Vector of h's
#' @param nV [int] Number of vertices
#' @noRd
#'
assemble_fem <- function(E, h_e, nV, petrov) {
    .Call(`_MetricGraph_assemble_fem`, E, h_e, nV, petrov)
}

#' @name projectVecLine
#' @title Projects SpatialPoints into SpatialLines
#' @description Obtain the coordinates of the projection of points into lines.
#' @param lines [nx2 matrix] Matrix of the points of the lines
#' @param points [nx2 matrix] Matrix of the points
#' @param normalized [int] 0 means not normalized, 1 means normalized
#' @noRd
#'
projectVecLine <- function(lines, points, normalized = 0L) {
    .Call(`_MetricGraph_projectVecLine`, lines, points, normalized)
}

#' @name interpolate2
#' @title Finds the point with respect to a distance along the line
#' @description Finds the point with respect to a distance along the line
#' @param lines [nx2 matrix] Matrix of the points of the lines
#' @param pos [k vector] vector of positions.
#' @param normalized [int] 0 means not normalized, 1 means normalized
#' @noRd
#'
interpolate2_aux <- function(lines, pos, normalized = 0L) {
    .Call(`_MetricGraph_interpolate2_aux`, lines, pos, normalized)
}

#' @name compute_length
#' @title Compute length
#' @description Computes the length of a piecewise-linear function whose coordinates are given in a matrix.
#' @param coords nx2 matrix Matrix of the points of the lines
#' @noRd
#'
compute_length <- function(coords) {
    .Call(`_MetricGraph_compute_length`, coords)
}

generate_mesh <- function(n_edges, edge_lengths, n_e, E, ind, continuous) {
    .Call(`_MetricGraph_generate_mesh`, n_edges, edge_lengths, n_e, E, ind, continuous)
}

