% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_plot.R
\name{bias_plot}
\alias{bias_plot}
\title{Plot used to visually assess the amount of bias of a new measurement method
 relative to a reference standard}
\usage{
bias_plot(object)
}
\arguments{
\item{object}{an object retunred by a call to \link{measure_compare}}
}
\description{
This function draws the "bias plot" which is used to visually assess the bias
 of the new method relative to a reference method. It is obtained by graphing a scatter plot
 of  \eqn{y_{1ij}} (new method) and \eqn{y_{2ij}} (reference method) versus the BLUP of y2 along with the two regression lines, and
 adds a second scale on the right showing the relationship between the
 estimated amount of bias and BLUP of y2.
}
\examples{
### load the data
data(data1)
### analysis
measure_model <- measure_compare(data1)
### Bias plot
bias_plot(measure_model)

}
\author{
Mingkai Peng
}

