% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{pValue_CherryFreqsChange_i}
\alias{pValue_CherryFreqsChange_i}
\title{Compute p-Values for Methylation Frequency Changes in Cherries}
\usage{
pValue_CherryFreqsChange_i(
  data,
  categorized_data = FALSE,
  index_islands,
  tree,
  input_control = TRUE
)
}
\arguments{
\item{data}{A list containing methylation states at tree tips for each genomic structure (e.g., island/non-island).
The data should be structured as \code{data[[tip]][[structure]]}, where each structure has the same number of sites across tips.
The input data must be prefiltered to ensure CpG sites are represented consistently across different tips.
Each element contains the methylation states at the sites in a given tip and structure
represented as 0, 0.5 or 1 (for unmethylated, partially-methylated and methylated).
If methylation states are not represented as 0, 0.5, 1 they are categorized
as 0 when value equal or under 0.2
0.5 when value between 0.2 and 0.8
and 1 when value over 0.8.
For customized categorization thresholds use \code{categorize_siteMethSt}}

\item{categorized_data}{Logical defaulted to FALSE.
TRUE to skip redundant categorization when methylation states are represented as 0, 0.5, and 1.}

\item{index_islands}{A numeric vector specifying the indices of islands to analyze.}

\item{tree}{A rooted binary tree in Newick format (character string) or as an \code{ape} phylo object with minimum 2 tips.}

\item{input_control}{Logical; if \code{TRUE}, validates input.}
}
\value{
A data frame containing tip pair information (first tip name, second tip name, first tip index, second tip index, distance)
and one column per island with the p-values from the chi-squared tests.
}
\description{
Calculates p-values for changes in methylation frequency between pairs of cherry tips in a phylogenetic tree.
A cherry is a pair of leaf nodes (also called tips or terminal nodes)
in a phylogenetic tree that share a direct common ancestor.
}
\details{
The function uses \code{simulate.p.value = TRUE} in \code{\link[stats]{chisq.test}}
to compute the p-value via Monte Carlo simulation to improve reliability
regardless of whether the expected frequencies meet the assumptions of the chi-squared test
(i.e., expected counts of at least 5 in each category).
}
\examples{
# Example with hypothetical tree and data structure

tree <- "((d:1,e:1):2,a:2);"
data <- list(
  #Tip 1
  list(c(rep(1,9), rep(0,1)), 
       c(rep(0,9), 1), 
       c(rep(0,9), rep(0.5,1))), 
  #Tip 2
  list(c(rep(0,9), rep(0.5,1)), 
       c(rep(0.5,9), 1), 
       c(rep(1,9), rep(0,1))), 
  #Tip 3
  list(c(rep(1,9), rep(0.5,1)), 
       c(rep(0.5,9), 1), 
       c(rep(0,9), rep(0.5,1)))) 

index_islands <- c(1,3)

pValue_CherryFreqsChange_i(data, categorized_data = TRUE, index_islands, tree)

}
