% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.MCmcmc.R
\name{pairs.MCmcmc}
\alias{pairs.MCmcmc}
\title{Create a pairs plot for an MCmcmc object}
\usage{
\method{pairs}{MCmcmc}(
  x,
  what = "sd",
  subset = NULL,
  col = NULL,
  pch = 16,
  cex = 0.2,
  scales = "free",
  ...
)
}
\arguments{
\item{x}{An \code{MCmcmc} object.}

\item{what}{Character indicating what parameters to plot.  Possible values
are \code{"sd"} or \code{"var"} which gives plots for the variance
components (on the sd. scale), \code{"beta"} or \code{"slope"}, which gives
plots for slope parameters and \code{"alpha"} or \code{"int"}, which gives
plots for the intercept parameters.}

\item{subset}{Character or numerical indicating the columns of the posterior
that should be plotted by \code{pairs}.}

\item{col}{Color of the lines points used for plotting of the posterior
densities.}

\item{pch}{Plot symbol for the points.}

\item{cex}{Plot character size for points in \code{pairs}.}

\item{scales}{Character vector of length two, with possible values "same" or
"free", indicating whether x- and y-axes of the plots should be constrained
to be the same across panels. For \code{pairs} only the first element is
used to decide whether all panles should have the same axes.}

\item{\dots}{Further aruments passed on to the \code{\link{Lattice}}
function called: \code{trace} calls \code{\link{xyplot}} from the
\code{coda} package, \code{post} calls \code{\link{densityplot}} from the
\code{coda} package, % \code{acf} calls \code{\link{acfplot}}, \code{pairs}
calls \code{\link{pairs}} from the \code{graphics} package.}
}
\value{
A \code{\link{Lattice}} plot.
}
\description{
Create a pairs plot for an MCmcmc object
}
\seealso{
\code{\link{MCmcmc}}, \code{\link{plot.MCmcmc}},
\code{\link{ox.MC}}, \code{\link{sbp.MC}}
}
\author{
Bendix Carstensen, Steno Diabetes Center, \email{bendix.carstensen@regionh.dk },
\url{http://BendixCarstensen.com}.
}
\keyword{models}
