% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetFreq.R
\name{MetFreq}
\alias{MetFreq}
\title{Frequency of Selected Metabolites from the LASSO, Elastic-net Cross-Validation}
\usage{
MetFreq(Object, TopK = 20, N = 3)
}
\arguments{
\item{Object}{An object of class \code{\link[MetabolicSurv]{cvle}} returned from the function \code{\link[MetabolicSurv]{CVLasoelacox}}.}

\item{TopK}{The number of Top K metabolites (5 by default) to be displayed in the frequency of selection graph.}

\item{N}{The metqbolites with the specified frequency should be displayed in the frequency of selection graph.}
}
\value{
A vector of metabolites and their frequency of selection. Also, a graphical representation is displayed.
}
\description{
The function selects the frquency of selection  from the shrinkage method (LASSO, Elastic-net) based on cross validation, that is the number of times each metabolite occur during the cross-validation process. In case of large metabolomic matrix then the N argument can be used to select metabolites occurence at a particular frequency.
}
\details{
This function outputs the mostly selected metabolites during the LASSO and Elastic-net cross validation. Selected top metabolites are ranked based on frequency of selection and also a particular frequency cqn be selected. In addition, it visualizes the selected top metabolites based on the minimum frequency specified.
}
\examples{
\donttest{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## CROSS-VALIDATION FOR LASSO AND ELASTIC-NET
Result = CVLasoelacox(Survival = Data$Survival,
Censor = Data$Censor, Mdata = t(Data$Mdata),
Prognostic = Data$Prognostic, Quantile = 0.5,
Metlist = NULL,Standardize = TRUE, Reduce=FALSE, Select=15,
Alpha = 1,Fold = 4,Ncv = 10,nlambda = 100)

## CONFIRMING THE CLASS
class(Result)

## USING THE FUNCTION
MetFreq(Result,TopK = 5, N=5)
}
}
\seealso{
\code{\link[MetabolicSurv]{cvmm}}, \code{\link[survival]{coxph}},
\code{\link[MetabolicSurv]{EstimateHR}},\code{\link[MetabolicSurv]{CVLasoelacox}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
