% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualization.R
\name{visualizeFeature}
\alias{visualizeFeature}
\title{Visualize Longitudinal Feature}
\usage{
visualizeFeature(
  df,
  text,
  group.levels,
  unit = "days",
  ylabel = "Normalized Count",
  col = c("blue", "firebrick"),
  prefix = "Test"
)
}
\arguments{
\item{df}{dataframe has the Count, Group, ID, Time}

\item{text}{feature name}

\item{group.levels}{The two level's name}

\item{unit}{time interval unit}

\item{ylabel}{text to be shown on the y-axis of all generated figures (default: "Normalized Count")}

\item{col}{two color to be used for the two groups (eg., c("red", "blue")).}

\item{prefix}{prefix to be used to create directory for the analysis results}
}
\description{
Visualize Longitudinal Feature
}
\examples{
data(metalonda_test_data)
pfx = tempfile()
dir.create(file.path(pfx))
n.sample = 5
n.timepoints = 10
n.group = 2
Group = factor(c(rep(0, n.sample*n.timepoints), rep(1, n.sample*n.timepoints)))
Time = rep(rep(1:n.timepoints, times = n.sample), 2)
ID = factor(rep(1:(2*n.sample), each = n.timepoints))
points = seq(1, 10, length.out = 10)
aggregate.df = data.frame(Count = metalonda_test_data[1,], Time = Time, Group = Group, ID = ID)
visualizeFeature(df = aggregate.df, text = rownames(metalonda_test_data)[1], 
group.levels = Group, prefix = pfx)
}
\references{
Ahmed Metwally (ametwall@stanford.edu)
}
