% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_base.R
\name{buildBaseDB}
\alias{buildBaseDB}
\title{Build the base database}
\usage{
buildBaseDB(
  outfolder,
  dbname,
  custom_csv_path = NULL,
  smitype = "Canonical",
  silent = TRUE,
  cl = 0,
  test = FALSE,
  doBT = FALSE,
  btOpts = "phaseII:1",
  btLoc,
  skipClean = F
)
}
\arguments{
\item{outfolder}{In which folder are you building your databases? Temp folders etc. will be put here.}

\item{dbname}{Which database do you want to build? Options: chebi,maconda,kegg,bloodexposome,dimedb,expoexplorer, foodb, drugbank, lipidmaps, massbank, metabolights, metacyc, phenolexplorer, respect, wikidata, wikipathways, t3db, vmh, hmdb, smpdb, lmdb, ymdb, ecmdb, bmdb, rmdb, stoff, anpdb, mcdb, mvoc, pamdb}

\item{custom_csv_path}{PARAM_DESCRIPTION, Default: NULL}

\item{smitype}{Which SMILES format do you want?, Default: 'Canonical'}

\item{silent}{Suppress warnings?, Default: TRUE}

\item{cl}{parallel::makeCluster object for multithreading, Default: 0}

\item{test}{Run in test mode? Makes an incomplete ver of db, but is faster.}

\item{doBT}{Do a biotransformation step using Biotransformer?}

\item{btOpts}{Biotransfomer -q options. Defaults to phase II transformation only.}

\item{btLoc}{Location of Biotransformer JAR file. Needs to be executable!}

\item{skipClean}{Skip cleaning step? Cleaning step uses SMILES to acquire formula, charge, and transforms SMILES into 'smitype' dialect.}
}
\value{
Nothing, writes SQLite database to 'outfolder'.
}
\description{
This is a large wrapper function that calls upon all individual database parsers, cleans the resulting database and saves it in a SQLite database.
}
\examples{
 \dontrun{buildBaseDB(outfolder = tempdir(), "lmdb", test=TRUE)}
}
\seealso{
\code{\link[data.table]{fread}},\code{\link[data.table]{as.data.table}}
 \code{\link[DBI]{dbDisconnect}}
}
