% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sampleOnMesh}
\alias{sampleOnMesh}
\title{Sampling on a mesh}
\usage{
sampleOnMesh(n, mesh)
}
\arguments{
\item{n}{number of simulations, a positive integer}

\item{mesh}{either a list containing (at least) two fields \code{vertices} 
(numeric matrix with three columns) and \code{faces} (integer matrix or 
list of integer vectors), otherwise a \strong{rgl} mesh (i.e. a 
\code{mesh3d} object)}
}
\value{
The simulated points on a matrix with three columns.
}
\description{
Uniformly samples points on a mesh.
}
\examples{
library(MeshesOperations)
library(rgl)
mesh <- torusMesh(R = 4, r = 2)
sims <- sampleOnMesh(200, mesh)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.75)
shade3d(mesh, color = "yellow")
points3d(sims, size = 5)
}
