% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_mvmedian-methods.R
\docType{methods}
\name{mr_mvmedian}
\alias{mr_mvmedian}
\alias{mr_mvmedian,MRMVInput-method}
\title{Multivariable median-based method}
\usage{
mr_mvmedian(
  object,
  distribution = "normal",
  alpha = 0.05,
  iterations = 10000,
  seed = 314159265
)

\S4method{mr_mvmedian}{MRMVInput}(
  object,
  distribution = "normal",
  alpha = 0.05,
  iterations = 10000,
  seed = 314159265
)
}
\arguments{
\item{object}{An \code{MRMVInput} object.}

\item{distribution}{The type of distribution used to calculate the confidence intervals. Options are \code{"normal"} (default) or \code{"t-dist"}.}

\item{alpha}{The significance level used to calculate the confidence intervals. The default value is 0.05.}

\item{iterations}{The number of bootstrap samples to generate when calculating the estimated standard error. The default value is 10000.}

\item{seed}{The random seed to use when generating the bootstrap samples (for reproducibility). The default value is 314159265. If set to \code{NA}, the random seed will not be set (for example, if the function is used as part of a larger simulation).}
}
\value{
The output from the function is an \code{MVMedian} object containing:

 \item{Exposure}{A character vector with the names given to the exposure.}
 \item{Outcome}{A character string with the names given to the outcome.}
 \item{Estimate}{A vector of causal estimates.}
 \item{StdError}{A vector of standard errors of the causal estimates.}
 \item{CILower}{The lower bounds of the causal estimates based on the estimated standard errors and the significance level provided.}
 \item{CIUpper}{The upper bounds of the causal estimates based on the estimated standard errors and the significance level provided.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Pvalue}{The p-values associated with the estimates (calculated as Estimate/StdError as per Wald test) using a normal or t-distribution (as specified in \code{distribution}).}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
}
\description{
The \code{mr_mvmedian} function performs multivariable Mendelian randomization via the median method. This is implemented by multivariable weighted quantile regression, with the quantile set to 0.5 (the median).
}
\details{
The multivariable median method is similar to the univariable weighted median method, except that it is implemented using quantile regression. The regression model is multivariable and weighted by the inverse of the variances of the variant-specific estimates. Confidence intervals are calculated by parametric bootstrap to estimate the standard error of the estimates, and then using quantiles of a normal or t-distribution (depending on the value of \code{distribution}).
}
\examples{
mr_mvmedian(mr_mvinput(bx = cbind(ldlc, hdlc, trig), bxse = cbind(ldlcse, hdlcse, trigse),
   by = chdlodds, byse = chdloddsse), iterations = 100)
  # iterations is set to 100 to reduce runtime for the mr_mvmedian method,
  # 10000 iterations are recommended in practice

}
