% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restructure.R
\name{restructure}
\alias{restructure}
\title{Restructure genotypic data}
\usage{
restructure(individual, struc = c("_", "g", "c", "cg"), check = FALSE)
}
\arguments{
\item{individual}{An individual (genotypic representation).}

\item{struc}{Character. Either of \code{c('_', 'g', 'c', 'cg')}}

\item{check}{Logical. Should checks be performed?}
}
\value{
A matrix or a list, depending on the parameter \code{struc}.
}
\description{
Restructure genotypic data into several forms.

This function is not yet official part of the package:
}
\details{
If \code{struc == '_'} (default), the result is a matrix (both chromosomes
and gametes are concatenated). If \code{struc == 'g'}, only gametes are concatenated
(chromosomes remain separated). If \code{struc == 'c'}, only chromosomes are concatenated
(gametes remain separated), and if \code{struc == 'cg'}, gametes get nested
within chromosomes, everything being separated.
}
\examples{
\dontrun{
data('exdat', package = 'Meiosis')
str(restructure(exdat$ind))
str(restructure(exdat$ind, struc = 'c'))
str(restructure(exdat$ind, struc = 'g'))
str(restructure(exdat$ind, struc = 'cg'))
}

}
\keyword{internal}
