% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2vcf.R
\name{Mega2VCF}
\alias{Mega2VCF}
\title{generate a VCF file set for a collection of markers}
\usage{
Mega2VCF(
  prefix,
  markers = NULL,
  mapno = 0,
  alleleOrder = "default",
  envir = ENV
)
}
\arguments{
\item{prefix}{prefix of output files including the VCF file (see Description section above). This prefix can include a path.}

\item{markers}{markers selected to be in the VCF output file}

\item{mapno}{specify which map index to use for genetic distances.  The function \code{showMapNames()}
will print out the internal map numbers corresponding to all the maps in the Mega2 database.}

\item{alleleOrder}{how to order alleles in VCF file.
'default' is Mega2order, 'minor' is minor allele freq first, 'major' is major allele freq
 first, and 'name' is ascending ascii character order of allele name.}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
None
}
\description{
Generate a VCF file from the specified Mega2 SQLite database.  The file is named \emph{"prefix".vcf}
 If the markers argument is.null(), the entire \bold{envir$markers} set is used, otherwise markers argument MUST
 be rows of the markers (\bold{envir$markers}) data frame.
 In addition,
 several other files are generated to hold additional database information: \emph{"prefix".fam}, \emph{"prefix".freq}, \emph{"prefix".map},
 \emph{"prefix".phe}, and \emph{"prefix".pen}, which contain the pedigree, allele frequency, marker genetic and
 physical map position, member phenotype and phenotype penetrance data.
}
\note{
This code in this package illustrates how to extract the various kinds of data in the
 Mega2 data frames to use for further processing.  Some of the data internal representations
 are a bit quirky but the code "explains" it all.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)
vcfdir = file.path(where_mega2rtutorial_data(), "vcfr")
if (!dir.exists(vcfdir)) dir.create(vcfdir)
vcffile = file.path(where_mega2rtutorial_data(), "vcfr", "vcf.01")
Mega2VCF(vcffile, ENV$markers[ENV$markers$chromosome == 1, ][1:10,], envir = ENV)
list.files(vcfdir)

}
