% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2gdsfmt.R
\name{Mega2gdsfmt}
\alias{Mega2gdsfmt}
\title{transcode mega2 to gdsfmt/SNP_ARRAY}
\usage{
Mega2gdsfmt(filename = "test.gds", markers = NULL, snp.order = FALSE,
  SeqArray = FALSE, envir = ENV)
}
\arguments{
\item{filename}{gdsfmt file to create}

\item{markers}{data frame of markers to be processed}

\item{snp.order}{TRUE indicates that the "genotype" data matrix has SNP as the first index
which changes more quickly than subsequent indices.  FALSE indicates that SAMPLE is the
the first index.}

\item{SeqArray}{TRUE uses SeqArray labels for the gdsfmt vector elements.  FALSE it uses labels
shown in SNPRelate}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
writes the "filename" file containing the CoreArray data.  Then returns an internal
  pointer, class .gds, to the file data.
}
\description{
Reads the data frames in "envir" and builds a GDSFMT COREARRAY file from them.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)
gdsfmtfile = file.path(where_mega2rtutorial_data(), "test.gds")
append_genotype_a = TRUE
append_genotype_b = append_genotype_c = FALSE
gn = Mega2gdsfmt(gdsfmtfile, envir=ENV)
gn

}
\seealso{
\code{\link{gdsfmt}}
}
