% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2pedgene.R
\name{init_pedgene}
\alias{init_pedgene}
\title{load Mega2 SQLite database and perform initialization for pedgene usage}
\usage{
init_pedgene(db = NULL, verbose = FALSE)
}
\arguments{
\item{db}{specifies the path of a \bold{Mega2} SQLite database containing study data.}

\item{verbose}{TRUE indicates that diagnostic printouts should be enabled.
This value is saved in the returned environment.}
}
\value{
"environment" containing data frames from an SQLite database and some computed values.
}
\description{
This populates the \bold{R} data frames from the specified \bold{Mega2} SQLite database.  It then
 prunes the samples to only include members that have a definite case or control
 status.  Undefined samples are ignored; this is necessary for CRAN \code{pedgene}.
}
\note{
\emph{init_pedgene} calculates schaidPed and pedPer that are used later in the \emph{Dopedgene} calculation.
 In addition, it initializes a matrix to aid
  in translating a genotype allele matrix to a genotype count matrix.

 It also initializes the dataframe \emph{envir$pedgene_results} to zero rows.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_pedgene(db)
ls(ENV)

}
\seealso{
\code{\link{DOpedgene}}, \code{\link{Mega2pedgene}}
}
