\name{ClustRandExample2}
\alias{ClustRandExample2}
\title{
Simulation-based design of a cluster-randomized trial (binary endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial where the primary efficacy endpoint is binary with a higher proportion indicating a more favorable outcome. A single dose or regimen of an experimental treatment will be compared to a control. An adaptive design with two interim analyses will be employed in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial). The following decision rules will be applied at the interim looks:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial may be stopped due to futility if a significant treatment effect is unlikely to be established at the final analysis (FA).
    \item Sample size re-estimation rule will be applied at the second interim analysis (IA2). The total number of patients in the trial will be increased to boost the probability of success if conditional power is lower than expected at this interim analysis.
} 
The following design parameters will be assumed:
\itemize{
    \item A trial design with a 1:2 randomization ratio will be used. A hundred patients will be enrolled in the control arm and twice as many patients will be enrolled in the experimental treatment arm.
    \item The patient dropout rate at the end of the treatment period is equal to 10\%.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 20\%.
    \item The promising interval at IA2 ranges from 50\% to 90\%.
    \item The target conditional power at IA2 is set to 90\% and the total sample size in the trial could be increased up to 40\%.
}
The response rates for the primary efficacy endpoint are assumed to be 10\% (control arm)and 25\% (experimental treatment arm).

Key operating characteristics of this adaptive design will be evaluated using the \code{\link{ClustRand}} function with 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ClustRandApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ClustRand}}, \code{\link{ClustRandExample1}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Binary"

# Direction of favorable outcome
parameters$direction = "Lower"

# Number of completers in the trial arms (control, multiple treatments)
parameters$sample_size = c(100, 100)

# Cluster scheme (fixed or random cluster sizes)
parameters$cluster_scheme = "Fixed"

# Vector of cluster sizes in the control arm 
parameters$control_cluster_size = rep(10, 10)

# Vector of cluster sizes in the treatment arm 
parameters$treatment_cluster_size = rep(10, 10)

# Response rate in the control arm 
parameters$control_rate = 0.6

# Intracluster correlation coefficient in the control arm 
parameters$control_icc = 0.3

# Response rate in the treatment arms 
parameters$treatment_rate = 0.3

# Intracluster correlation coefficient in the treatment arms
parameters$treatment_icc = 0.3

# Data analysis method (generalized estimating equations (GEE) 
# or generalized linear mixed effects model (GLMEM))
parameters$method_type = "GLMEM"

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations
parameters$nsims = 10

# Number of cores for parallel calculations
parameters$ncores = 1

# Run simulations to compute operating characteristics
results = ClustRand(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ClustRand Binary endpoint.docx", fileext=".docx"))
}