\name{fit.peak.profile}
\alias{fit.peak.profile}
\alias{plot.fit.peak.profile}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Iteratively learn deconvolution kernel (peak profile) from real
  ChIP-chip data.}
\description{
  Learn the peak profile from ChIP-chip data, to be used for data
  deconvolution via 'chip.deconv' or 'deconv.entire.genome'.
}
\usage{
fit.peak.profile(data, tile.size, n.peaks = 30, n.skip = 10, in.kernel =
NA, fits = NULL, method = "Nelder-Mead", positions=c( 0, 25, 50, 100,
150, seq( 200, (mini.window*1.5)+1, by=100 ) ), re.fit = 25, start.pars
= c(shape = 7, scale = 50, bs.size = 20, h.cutoff = 15), to.be.fit=c(
"shape", "scale", "bs.size", "h.cutoff" ), rnd = F, mini.window = max(5
* tile.size, 1300), plot = T, name = "", no.multicore=T, ...)

plot.fit.peak.profile(x, n.peak.plot = 7, plot.spline = F, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{Input data matrix, connection, or file name. See
    'chip.deconv' for details.}
  \item{tile.size}{Probe length (bp) for use in kernel generation. See
    'generate.binding.profile' for details.}
  \item{n.peaks}{Number of (biggest) peaks to learn from}
  \item{n.skip}{Skip this many worst-fitting of the 'n.peaks'. Enables
    filtering out of peaks that don't agree with the majority of
    isolated peaks.}
  \item{in.kernel}{Input seed kernel to start with (guessed if 'NA').}
  \item{fits}{Input preliminary fits (via 'deconv.entire.genome';
    generated from input data if 'NULL').}
  \item{method}{Optimization method, see 'optim'}
  \item{positions}{Passed directly to 'generate.binding.profile'}
  \item{re.fit}{Re-run 'deconv.entire.genome' on input data using
    current best-fit profile, every 're.fit' iterations}
  \item{start.pars}{Starting parameters for model profile. See Details.}
  \item{to.be.fit}{Names of parameters to be learned. See Details.}
  \item{rnd}{Add some 'jitter' to the starting parameters}
  \item{plot}{Plot the fit as it progresses (including data and fit to
    several bright peaks in the data)}
  \item{mini.window}{Size of window to be plotted around each of the
    bright peaks, if 'plot' is TRUE}
  \item{no.multicore}{Prevent use of multiple cores, even if 'multicore'
  is installed.}  
  \item{name}{Ignored}
  \item{\dots}{Further parameters for 'deconv.entire.genome' and 'generate.binding.profile'}

  \item{x}{Object output from 'fit.peak.profile'}
  \item{n.peak.plot}{Number of bright peaks (and their fits) to include
    in the plot}
  \item{plot.spline}{Plot a 'smooth.spline' fit to the data for reference}
}
\details{
  'fit.peak.profile' iteratively runs 'deconv.entire.genome' on a data
  set, isolates the 'n.peaks' brightest peaks, and fits parameters to
  the model profile use by 'generate.binding.profile', then re-fits the
  data using 'deconv.entire.genome'. Currently, the parameters that are
  fit include the shape and scale of the Gamma function used for the
  fragment length distribution, the binding site footprint, and the
  "cutoff" for hybridization. All parameters listed in 'to.be.fit' will
  be optimized. Parameters not listed in 'start.pars' will be set to the
  defaults.
}
\value{
  A list of class 'fit.peak.profile, for which a 'plot' function
  exists, and containing the following elements:
  \item{score}{The log of the RSS of the final peak profile to the
    'n.peaks - 'n.skip' brightest isolated peaks in the data (this is
    the measure that was optimized).}
  \item{kernel}{The final peak profile, generated by
    'generate.binding.profile'.}
  \item{new.fits}{The deconvolution fits of the final peak profile to
    the 'n.peaks' brightest peaks in the data, generated by 'chip.deconv'.}
  \item{is.bad}{Logical vector telling which of the 30 'n.peaks'
    brightest peaks were not among the 'n.skip' poorly-fitting peaks.}
  \item{par}{Final best-fit model parameters for the peak profile.}
  \item{peaks}{Two-column matrix listing the centers and intensities of
    the 'n.peaks' brightest peaks in the data, that were used for the
    fitting.}
  \item{args}{All parameters input to 'fit.peak.profile', for future
    reference.}
}
\references{
  Reiss, DJ and Facciotti, MT and Baliga, NS. (2007). "Model-based
  deconvolution of genome-wide DNA binding",
  Bioinformatics; doi: 10.1093/bioinformatics/btm592. \cr

  http://baliga.systemsbiology.net/medichi\cr
}
\author{
  David J Reiss, Institute for Systems Biology
  
  Maintainer: <dreiss@systemsbiology.org>
}
\seealso{
  chip.deconv, deconv.entire.genome, generate.fake.data,
  generate.binding.profile, MeDiChI-data,
  \code{lars}, \code{quadprog}, \code{Matrix}
}
\examples{
  ## Fit the peak profile to the high-resolution Nimblegen data,
  ## plotting progress. Note this will take some time.
  data( "halo.hires", package="MeDiChI" )

\dontrun{
   params <- fit.peak.profile( data.halo.hires, tile.size=50, 
                             quant.cutoff="q0.99", chrom="Chr",
                             fit.res=30, max.steps=100, plot=TRUE )
   plot( params )

  ## Use the output kernel for deconvolution (see 'deconv.entire.genome'):
   fits <- deconv.entire.genome( data.halo.lowres, fit.res=10,
                n.boot=1, kernel=params\$kernel, verbose=TRUE, trace=FALSE )
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{methods}
