% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertUSIndianLands.R
\name{convertUSIndianLands}
\alias{convertUSIndianLands}
\title{Convert Indian Lands Shapefile}
\usage{
convertUSIndianLands(nameOnly = FALSE, simplify = TRUE)
}
\arguments{
\item{nameOnly}{Logical specifying whether to only return the name without
creating the file.}

\item{simplify}{Logical specifying whether to create "_05", _02" and "_01"
versions of the file that are simplified to 5\%, 2\% and 1\%.}
}
\value{
Name of the dataset being created.
}
\description{
Create a SpatialPolygonsDataFrame for Native American land.
}
\details{
A Native American land shapefile is downloaded and converted to a
SpatialPolygonsDataFrame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

The source data is from 2014.
}
\note{
From the source documentation:

 This map layer shows Indian lands of the United States. For the most part,
 only areas of 320 acres or more are included; some smaller areas deemed to
 be important or significant are also included. Federally-administered lands
 within a reservation are included for continuity; these may or may not be
 considered part of the reservation and are simply described with their
 feature type and the administrating Federal agency. Some established Indian
 lands which are larger than 320 acres are not included in this map layer
 because their boundaries were not available from the owning or administering
 agency.The USIndianLands shapefile represents lands administered by the
 Bureau of Indian Affairs, ie. Indian reservations

 These data are intended for geographic display and analysis at the national
 level, and for large regional areas. The data should be displayed and
 analyzed at scales appropriate for 1:1,000,000-scale data. No responsibility
 is assumed by the National Atlas of the United States in the use of these data.
 and is compiled by the National Atlas of the United States of America.
}
\references{
\url{https://www.sciencebase.gov/catalog/item/5d150464e4b0941bde5b7658}
}
\seealso{
setSpatialDataDir

getVariable
}
\keyword{datagen}
