% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertNWSFireZones.R
\name{convertNWSFireZones}
\alias{convertNWSFireZones}
\title{Convert NWS Public Forecast Zones Shapefile}
\usage{
convertNWSFireZones(nameOnly = FALSE, simplify = TRUE)
}
\arguments{
\item{nameOnly}{Logical specifying whether to only return the name without
creating the file.}

\item{simplify}{Logical specifying whether to create "_05", _02" and "_01"
versions of the file that are simplified to 5\%, 2\% and 1\%.}
}
\value{
Name of the dataset being created.
}
\description{
Create a SpatialPolygonsDataFrame for NWS weather forecast zones
}
\details{
A NWS forecast zone shapefile is downloaded and converted to a
SpatialPolygonsDataFrame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

The source data is from 2020.
}
\note{
From the source documentation:

This data set is used to delineate the Fire Weather Zones that are used by
NWS in the fire weather forecast program.
}
\references{
\url{https://www.weather.gov/gis/FireZones}
}
\seealso{
setSpatialDataDir

getVariable
}
\keyword{datagen}
