% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mazama_initialize.R
\name{mazama_initialize}
\alias{mazama_initialize}
\title{Initialize with MazamaScience standard directories}
\usage{
mazama_initialize(spatialDataDir = "~/Data/Spatial")
}
\arguments{
\item{spatialDataDir}{Directory where spatial datasets are found, 
Default: "~/Data/Spatial"}
}
\value{
No return value.
}
\description{
Convenience function to initialize spatial data. Wraps the 
following setup lines:

\preformatted{
MazamaSpatialUtils::setSpatialDataDir(spatialDataDir)

MazamaSpatialUtils::loadSpatialData("EEZCountries")
MazamaSpatialUtils::loadSpatialData("OSMTimezones")
MazamaSpatialUtils::loadSpatialData("NaturalEarthAdm1")
MazamaSpatialUtils::loadSpatialData("USCensusCounties")
}
}
\examples{
\donttest{
# Set up directory for spatial data
spatialDataDir <- tempdir() # typically "~/Data/Spatial"
MazamaSpatialUtils::setSpatialDataDir(spatialDataDir)

# Install core spatial datasets (168 MB download)
MazamaSpatialUtils::installSpatialData()

exists("NaturalEarthAdm1")
mazama_initialize(spatialDataDir)
exists("NaturalEarthAdm1")
class(NaturalEarthAdm1)
}
}
