% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMWRresults.R
\name{readMWRresults}
\alias{readMWRresults}
\title{Read water quality monitoring results from an external file}
\usage{
readMWRresults(respth, runchk = TRUE, warn = TRUE, tzone = "America/Jamaica")
}
\arguments{
\item{respth}{character string of path to the results file}

\item{runchk}{logical to run data checks with \code{\link{checkMWRresults}}}

\item{warn}{logical to return warnings to the console (default)}

\item{tzone}{character string for time zone, passed to \code{\link{formMWRresults}}}
}
\value{
A formatted water quality monitoring results data frame that can be used for downstream analysis
}
\description{
Read water quality monitoring results from an external file
}
\details{
Date are imported with \code{\link[readxl]{read_excel}}, checked with \code{\link{checkMWRresults}}, and formatted with \code{\link{formMWRresults}}.
}
\examples{
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

resdat <- readMWRresults(respth)
head(resdat)
}
\seealso{
\code{\link{readMWRresultsview}} for troubleshooting import checks
}
