% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRinput.R
\name{utilMWRinput}
\alias{utilMWRinput}
\title{Utility function to import data as paths or data frames}
\usage{
utilMWRinput(
  res = NULL,
  acc = NULL,
  frecom = NULL,
  sit = NULL,
  wqx = NULL,
  fset = NULL,
  runchk = TRUE,
  warn = TRUE
)
}
\arguments{
\item{res}{character string of path to the results file or \code{data.frame} for results returned by \code{\link{readMWRresults}}}

\item{acc}{character string of path to the data quality objectives file for accuracy or \code{data.frame} returned by \code{\link{readMWRacc}}}

\item{frecom}{character string of path to the data quality objectives file for frequency and completeness or \code{data.frame} returned by \code{\link{readMWRfrecom}}}

\item{sit}{character string of path to the site metadata file or \code{data.frame} for site metadata returned by \code{\link{readMWRsites}}}

\item{wqx}{character string of path to the wqx metadata file or \code{data.frame} for wqx metadata returned by \code{\link{readMWRwqx}}}

\item{fset}{optional list of inputs with elements named \code{res}, \code{acc}, \code{frecom}, \code{sit}, or \code{wqx}, overrides the other arguments, see details}

\item{runchk}{logical to run data checks with \code{\link{checkMWRresults}}, \code{\link{checkMWRacc}}, \code{\link{checkMWRfrecom}}, \code{\link{checkMWRsites}}, or \code{\link{checkMWRwqx}}, applies only if \code{res}, \code{acc}, \code{frecom}, \code{sit}, or \code{wqx} are file paths}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
A five element list with the imported results, data quality objective files, site metadata, and wqx metadata, named \code{"resdat"}, \code{"accdat"}, \code{"frecomdat"}, \code{"sitdat"}, and \code{"wqxdat"}, respectively.
}
\description{
Utility function to import data as paths or data frames
}
\details{
The function is used internally by others to import data from paths to the relevant files or as data frames returned by \code{\link{readMWRresults}}, \code{\link{readMWRacc}}, \code{\link{readMWRfrecom}}, \code{\link{readMWRsites}}, or \code{\link{readMWRwqx}}.  For the former, the full suite of data checks can be evaluated with \code{runkchk = T} (default) or suppressed with \code{runchk = F}.

The \code{fset} argument can used in place of the preceding arguments. The argument accepts a list with named elements as \code{res}, \code{acc}, \code{frecom}, \code{sit}, or \code{wqx}, where the elements are either character strings of the path or data frames to the corresponding inputs. Missing elements will be interpreted as \code{NULL} values.  This argument is provided as convenience to apply a single list as input versus separate inputs for each argument.

Any of the arguments for the data files can be \code{NULL}, used as a convenience for downstream functions that do not require all.
}
\examples{
##
# using file paths

# results path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', package = 'MassWateR')

# frequency and completeness path
frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', 
     package = 'MassWateR')

# site path
sitpth <- system.file('extdata/ExampleSites.xlsx', package = 'MassWateR')

# wqx path
wqxpth <- system.file('extdata/ExampleWQX.xlsx', package = 'MassWateR')

inp <- utilMWRinput(res = respth, acc = accpth, frecom = frecompth, sit = sitpth, wqx = wqxpth)
inp$resdat
inp$accdat
inp$frecomdat
inp$sitdat
inp$wqxdat

##
# using data frames

# results data
resdat <- readMWRresults(respth)

# accuracy data
accdat <- readMWRacc(accpth)

# frequency and completeness data
frecomdat <- readMWRfrecom(frecompth)

# site data
sitdat <- readMWRsites(sitpth)

# wqx data
wqxdat <- readMWRwqx(wqxpth)

inp <- utilMWRinput(res = resdat, acc = accdat, frecom = frecomdat, sit = sitdat, wqx = wqxpth)
inp$resdat
inp$accdat
inp$frecomdat
inp$sitdat
inp$wqxdat

##
# using fset as list input

# input with paths to files
fset <- list(
  res = respth, 
  acc = accpth, 
  frecom = frecompth,
  sit = sitpth, 
  wqx = wqxpth
)
utilMWRinput(fset = fset)
}
