% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMWRfrecom.R
\name{readMWRfrecom}
\alias{readMWRfrecom}
\title{Read data quality objectives for frequency and completeness from an external file}
\usage{
readMWRfrecom(frecompth, runchk = TRUE, warn = TRUE)
}
\arguments{
\item{frecompth}{character string of path to the data quality objectives file for frequency and completeness}

\item{runchk}{logical to run data checks with \code{\link{checkMWRfrecom}}}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
A formatted data frame of data quality objectives for frequency and completeness that can be used for downstream analysis
}
\description{
Read data quality objectives for frequency and completeness from an external file
}
\details{
Data are imported with \code{\link[readxl]{read_excel}} and checked with \code{\link{checkMWRfrecom}}.
}
\examples{
frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', 
     package = 'MassWateR')

frecomdat <- readMWRfrecom(frecompth)
head(frecomdat)
}
