% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMWRresultsview.R
\name{readMWRresultsview}
\alias{readMWRresultsview}
\title{Create summary spreadsheet of the water quality monitoring results}
\usage{
readMWRresultsview(
  respth,
  columns = NULL,
  output_dir,
  output_file = NULL,
  maxlen = 8
)
}
\arguments{
\item{respth}{character string of path to the results file}

\item{columns}{character string indicating which columns to view, defaults to all}

\item{output_dir}{character string of the output directory for the rendered file}

\item{output_file}{optional character string for the name of the .csv file output, must include the file extension}

\item{maxlen}{numeric to truncate numeric values to the specified length}
}
\value{
Creates a spreadsheet at the location specified by \code{output_dir}. Each column shows the unique values.
}
\description{
Create summary spreadsheet of unique values for each column in the water quality results file to check for data mistakes prior to running the \code{\link{readMWRresults}} function
}
\details{
Acceptable options for the \code{columns} argument include any of the column names in the results file. The default setting (\code{NULL}) will show every column in the results file.

The output of this function can be useful to troubleshoot the checks when importing the water quality monitoring result file with \code{readMWRresults} (see \href{https://massbays-tech.github.io/MassWateR/articles/MassWateR.html#data-import-and-checks}{https://massbays-tech.github.io/MassWateR/articles/MassWateR.html#data-import-and-checks}).
}
\examples{
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# all columns
readMWRresultsview(respth, output_dir = tempdir())

# parameters and units
readMWRresultsview(respth, columns = c('Characteristic Name', 'Result Unit'),
   output_dir = tempdir())
}
