% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RHT2.R
\name{RHT2}
\alias{RHT2}
\title{Robust Hotelling T^2 Test for One Sample in High Dimensional Data}
\usage{
RHT2(data, mu0, alpha = 0.75, d, q)
}
\arguments{
\item{data}{the data. It must be matrix or data.frame.}

\item{mu0}{the mean vector which will be used to test the null hypothesis.}

\item{alpha}{numeric parameter controlling the size of the subsets over which the determinant is minimized. 
Allowed values are between 0.5 and 1 and the default is 0.75.}

\item{d}{the constant in Equation (11) in the study by Bulut (2021).}

\item{q}{the second degree of freedom value of the approximate F distribution in Equation (11) in the study by Bulut (2021).}
}
\value{
a list with 3 elements:
\item{T2}{The Robust Hotelling T^2 value in high dimensional data}
\item{Fval}{The F value based on T2}
\item{pval}{The p value based on the approximate F distribution}
}
\description{
Robust Hotelling T^2 Test for One Sample in high Dimensional Data
}
\details{
\code{RHT2} function performs a robust Hotelling T^2 test in high dimensional test based on the minimum regularized covariance determinant estimators.
This function needs the q and d values. These values can be obtained \code{simRHT2} function.  
For more detailed information, you can see the study by Bulut (2021).
}
\examples{

library(rrcov)
data(octane)
mu.clean<-colMeans(octane[-c(25,26,36,37,38,39),])

RHT2(data=octane,mu0=mu.clean,alpha=0.84,d=1396.59,q=1132.99)
}
\references{
Bulut, H (2021). A robust Hotelling test statistic for one sample case in high dimensional data,
Communication in Statistics: Theory and Methods.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
