% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_muac.R
\name{plotmuac}
\alias{plotmuac}
\title{Plots MUAC z-scores and percentiles on references curves.}
\usage{
plotmuac(
  age,
  sex,
  muac,
  age_range = "3-60",
  graphtype = "z-scores",
  lwd = 1,
  line.color = "skyblue",
  size.label = 4,
  size.score = 5,
  Notes = FALSE
)
}
\arguments{
\item{age}{a numeric value (in months) between 3 and 228 depending on the age_range.}

\item{sex}{preferably numeric (1 = Male, 2 = Female).
Strings (such as "Male", "Female") can also be used.}

\item{muac}{a numeric mid upper arm circumference value in cm.}

\item{age_range}{age range in months. Input has to be characters.
Options allowed are: "3-60" which is the default, or "60-228".}

\item{graphtype}{A character input is required: "z-scores" or "percentiles".}

\item{lwd}{Line width allows you to specify a numeric value that control the
width of the line plots. By dafult, it is set to 1.}

\item{line.color}{The color of the lines. It is set to "skyblue" by default.}

\item{size.label}{size of the label for calculated z-score or percentile}

\item{size.score}{refers to the size of the text for the calculated z-scores
(-3,-2,-1,0,1,2,3) or the percentiles.}

\item{Notes}{Is FALSE by default. If set to TRUE, 'notes' will be printed on the
console about the nature, range of variables allowed and number of records processed.}
}
\value{
Plots z-scores or percentiles with a mark indicating where the
individual person lies within the standardized reference curves.
}
\description{
Plots individual MUAC z-scores and percentiles on standardized growth references
 using the LMS method for children and adolescents aged 3 months to 19 years.
}
\examples{
g1 <- plotmuac(age = 48, sex = 2, muac = 16.2, line.color = "orange")

g2 <- plotmuac(age = 48, sex = 2, muac = 16.2, graphtype = "percentiles",
              line.color = "orange")

g3 <- plotmuac(age = c(24, 36, 48, 59), sex = 1, muac = c(13, 14.5, 16.1, 21.7))

g4 <- plotmuac(age = c(24, 36, 48, 59), sex = 1, muac = c(13, 14.5, 16.1, 21.7),
              graphtype = "percentiles")

g5 <- plotmuac(age = c(61, 73, 181, 217), sex = 1, muac = c(13, 15.7, 34.1, 43.9),
              age_range = "60-228")

g6 <- plotmuac(age = c(61, 73, 181, 217), sex = 1, muac = c(13, 15.7, 34.1, 43.9),
              age_range = "60-228", graphtype = "percentiles")


}
\references{
Mramba L., Ngari M., Mwangome M., Muchai L., Bauni E., Walker A.S., Gibb D.M., Fegan G. and Berkley J.A. (2017)
\emph{A growth reference for mid upper arm circumference for age among school age children and adolescents,
and validation for mortality: growth curve construction and longitudinal cohort study}
BMJ 2017;358:j3423 <doi:10.1136/bmj.j3423>

<https://www.bmj.com/content/358/bmj.j3423>

<https://www.bmj.com/content/358/bmj.j3423/related#datasupp>

<https://www.who.int/childgrowth/standards/Technical_report.pdf>

<https://www.who.int/childgrowth/standards/ac_for_age/en/>
}
\seealso{
\code{\link{indivmuaczs}}, \code{\link{muaczs}},  \code{\link{bmizs}}, \code{\link{muacz.bmiz}} and \code{\link{plotbmi}}.
}
