% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{plot.data_descr}
\alias{plot.data_descr}
\title{Plot descriptive statistics for partial rankings}
\usage{
\method{plot}{data_descr}(
  x,
  cex_text_mean = 1,
  cex_symb_mean = 12,
  cex_text_pc = 3,
  cex_range_pc = c(8, 20),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"data_descr"} returned by \code{\link{data_description}}.}

\item{cex_text_mean}{Positive scalar: the magnification to be used for all the labels in the plot for the mean rank vector. Defaults to 1.}

\item{cex_symb_mean}{Positive scalar: the magnification to be used for the symbols in the pictogram of the mean rank vector. Defaults to 12.}

\item{cex_text_pc}{Positive scalar: the magnification to be used for all the labels in the bubble plot of the paired comparison frequencies. Defaults to 3.}

\item{cex_range_pc}{Numeric vector indicating the range of values to be used on each axis in the bubble plot of the paired comparison frequencies. Defaults to \code{c(8,20)}.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
Produce 5 plots to display descriptive summaries of the partial ranking dataset, namely: i) a barplot of the frequency distribution (\%) of the number of ranked items (i.e., the length of the partial sequences), ii) a basic pictogram of the mean rank vector, iii) a heatmap of the first-order marginals, iv) the ecdf of the marginal rank distributions and v) a bubble plot of the pairwise comparison matrix.
}
\description{
\code{plot} method for class \code{"data_descr"}.
}
\examples{

## Example 1. Plot sample statistics for the Antifragility dataset.
desc <- data_description(ranks_antifragility)
plot(desc)

## Example 2. Plot sample statistics for the Sports dataset.
r_sports <- ranks_sports[, 1:8]
desc <- data_description(rankings = r_sports, borda_ord = TRUE)
plot(desc, cex_text_mean = 1.2)

## Example 3. Plot sample statistics for the Sports dataset by gender.
r_sports <- ranks_sports[, 1:8]
desc_f <- data_description(rankings = r_sports, subset = (ranks_sports$Gender == "Female"))
plot(desc_f, cex_text_mean = 1.2)
desc_m <- data_description(rankings = r_sports, subset = (ranks_sports$Gender == "Male"))
plot(desc_m, cex_text_mean = 1.2)


}
\references{
Wickham H (2016). ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York. ISBN 978-3-319-24277-4, \url{https://ggplot2.tidyverse.org}.
}
\seealso{
\code{\link{data_description}}
}
