% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_LRTest.R
\name{MMCLRTest}
\alias{MMCLRTest}
\title{Maximized Monte Carlo Likelihood Ratio Test}
\usage{
MMCLRTest(Y, p, k0, k1, Z = NULL, control = list())
}
\arguments{
\item{Y}{Series to be tested. Must be a (\code{T x q}) matrix  where T is the number of time observations and q is the number of variables.}

\item{p}{Number of autoregressive lags. Must be greater than or equal to 0.}

\item{k0}{Number of regimes under null hypothesis. Must be greater than or equal to 1.}

\item{k1}{Number of regimes under alternative hypothesis. Must be greater than \code{k0}.}

\item{Z}{Exogenous regressors. Optional input and default is NULL. When used, it should be a (\code{T x qz}) matrix where T is the number of time observations and q is the number of exogenous variables.}

\item{control}{List with test procedure options including: 
\itemize{
  \item N: Integer determining the number of Monte Carlo simulations. Default is set to \code{99} as in paper.
  \item burnin: Number of simulated observations to remove from beginning. Default is \code{100}.
  \item converge_check: String of NULL determining if convergence of model(s) should be verified. Allowed inputs are: "null", "alt", "both", or \code{NULL}. If \code{NULL} (default) no model convergence is verified.
  \item workers: Integer determining the number of workers to use for parallel computing version of test. Note that parallel pool must already be open. Default is \code{0}.
  \item type: String that determines the type of optimization algorithm used. Arguments allowed are: \code{"pso"}, \code{"GenSA"}, and \code{"GA"}. Default is \code{"pso"}.
  \item eps: Double determining the constant value that defines a consistent set for search. Default is \code{0.1}.
  \item CI_union: Boolean determining if union of set determined by \code{eps} and confidence set should be used to define consistent set for search. Default is \code{TRUE}.
  \item lambda: Double determining penalty on nonlinear constraint. Default is \code{100}.
  \item stationary_constraint: Boolean determining if only stationary solutions are considered (if \code{TRUE}) or not (if \code{FALSE}). Default is \code{TRUE}.
  \item phi_low: Vector with lower bound for autoregressive parameters when optimizing. Default is \code{NULL}.
  \item phi_upp: Vector with upper bound for autoregressive parameters when optimizing. Default is \code{NULL}.
  \item P_low: Value with lower bound for transition probabilities when optimizing. Default is \code{0}.
  \item P_upp: Value with upper bound for transition probabilities when optimizing. Default is \code{1}.
  \item variance_constraint: Double used to determine the lower bound for variance in parameter set for search. Value should be between \code{0} and \code{1} as it is multiplied by consistent point estimates of variances. Default is \code{0.01} (i.e., \code{1\%} of consistent point estimates.
  \item silence: Boolean determining if optimization steps should be silenced (if \code{TRUE}) or not (if \code{FALSE}). Default is \code{FALSE}.
  \item threshold_stop: Double determining the global optimum of function. Default is \code{1}.
  \item mdl_h0_control: List with restricted model options. See \code{\link{Nmdl}}, \code{\link{ARmdl}}, \code{\link{VARmdl}}, \code{\link{HMmdl}}, \code{\link{MSARmdl}}, or \code{\link{MSVARmdl}} documentation for available and default values.
  \item mdl_h1_control: List with unrestricted model options. See \code{\link{HMmdl}}, \code{\link{MSARmdl}}, or \code{\link{MSVARmdl}} documentation for available and default values.
  \item use_diff_init_sim: Value which determines the number of initial values to use when estimating models for null distribution. Default is set to use the same as specified in \code{mdl_h0_control} and \code{mdl_h1_control}.
  \item optim_control: List with optimization algorithm options. See \code{\link[pso]{psoptim}}, \code{\link[GenSA]{GenSA}}, \code{\link[GA]{ga}}. Default is to set \code{list(maxit = 200)} so that maximum number of iterations is \code{200}.
}}
}
\value{
List of class \code{LMCLRTest} (\code{S3} object) with attributes including: 
\itemize{
  \item mdl_h0: List with restricted model attributes. 
  \item mdl_h1: List with unrestricted model attributes. 
  \item LRT_0: Value of test statistic from observed data.
  \item LRN: A (\code{N x 1}) vector of test statistics from data simulated under the null hypothesis.
  \item pval: P-value of Local Monte Carlo Likelihood Ratio Test.
  \item LRN_cv: Vector with 90\%, 95\%, and 99\% Monte Carlo simulated critical values (from vector \code{LRN}). These are not asymptotic critical values. 
  \item control: List with test procedure options used.
}
}
\description{
This function performs the Maximized Monte Carlo likelihood ratio 
test (MMC-LRT) proposed in Rodriguez-Rondon & Dufour (2024).
}
\examples{

set.seed(1234)
# Define DGP of MS AR process
mdl_ms2 <- list(n     = 200, 
                mu    = c(5,10),
                sigma = c(1,4),
                phi   = c(0.5),
                k     = 2,
                P     = rbind(c(0.90, 0.10),
                              c(0.10, 0.90)))

# Simulate process using simuMSAR() function
y_ms_simu <- simuMSAR(mdl_ms2)


# Set test procedure options
mmc_control = list(N = 19,
                   burnin = 100,
                   converge_check = NULL,
                   eps = 0.1,
                   CI_union = TRUE,
                   silence = FALSE,
                   threshold_stop = 0.05 + 1e-6,
                   type = "pso",
                   maxit = 50,
                   mdl_h0_control = list(const  = TRUE, 
                                         getSE  = TRUE),
                   mdl_h1_control = list(msmu   = TRUE, 
                                         msvar  = TRUE,
                                         getSE  = TRUE,
                                         method = "EM",
                                         use_diff_init = 1))
\donttest{
  MMCtest <- MMCLRTest(y_ms_simu$y, p = 1 , k0 = 1, k1 = 2, control = mmc_control)
  summary(MMCtest)
}



}
\references{
Rodriguez-Rondon, Gabriel and Jean-Marie Dufour. 2022. "Simulation-Based Inference for Markov Switching Models” \emph{JSM Proceedings, Business and Economic Statistics Section: American Statistical Association}.

Rodriguez-Rondon, Gabriel and Jean-Marie Dufour. 2025. “Monte Carlo Likelihood Ratio Tests for Markov Switching Models.” \emph{Unpublished manuscript}.
}
