% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_init_doc.R
\name{OMinit}
\alias{OMinit}
\title{Initialize Operating Model}
\usage{
OMinit(
  name = NULL,
  ...,
  files = c("xlsx", "rmd"),
  dir = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{name}{The name of the Excel and source.rmd file to be created in the working directory (character).
Use 'example' for a populated example OM XL and documentation file.}

\item{...}{Optional MSEtool objects to use as templates: OM, Stock, Fleet, Obs, or Imp objects}

\item{files}{What files should be created: 'xlsx', 'rmd', or c('xlsx', 'rmd') (default: both)
to use as templates for the Operating Model.}

\item{dir}{Optional file path to create the xlsx and rmd files. Default is \code{getwd()}}

\item{overwrite}{Logical. Should files be overwritten if they already exist?}
}
\value{
name.xlsx and name.rmd files are created in the working directory.
}
\description{
Generates an Excel spreadsheet and a source.rmd file in the current working directory for
specifying and documenting a MSEtool Operating Model.
}
\examples{
\dontrun{
# Create an Excel OM template and rmd file called 'myOM.xlsx' and 'myOM.rmd':
OMinit('myOM')

# Create an Excel OM template and text file called 'myOM.rmd' and 'myOM.rmd', using
# another OM as a template:
OMinit('myOM', myOM)

# Create an Excel OM template and text file called 'myOM.rmd' and 'myOM.rmd', using
# the Stock object 'Herring' as a template:
OMinit('myOM', Herring)

# Create an Excel OM template and text file called 'myOM.rmd' and 'myOM.rmd', using
# the Stock object 'Herring', and Obs object 'Generic_obs' as templates:
OMinit('myOM', Herring, Generic_obs)
}

}
\author{
A. Hordyk
}
